//Enhanced BApplication.  Provides facilities for registering windows and background
//threads and quits the application after the last window or thread is unregistered.

#include "DocumentApp.h"


DocumentApp::DocumentApp(const char* a_signature)
: BApplication(a_signature)
{
	m_window_and_process_holds = 0;
	m_quit_process = false;
}


DocumentApp::~DocumentApp()
{ }


bool DocumentApp::QuitRequested()
{
	m_quit_process = true;
	return BApplication::QuitRequested();
}


void DocumentApp::CancelQuitProcess()
{
	m_quit_process = false;
}


bool DocumentApp::IsQuitInProgress()
{
	return m_quit_process;
}


void DocumentApp::RegisterWindow()
{
	m_quit_process = false;
	ProcessHold();
}


void DocumentApp::UnregisterWindow()
{
	ProcessDone();
}


void DocumentApp::ProcessHold()
{
	atomic_add(&m_window_and_process_holds,1);
}


void DocumentApp::ProcessDone()
{
	if(atomic_add(&m_window_and_process_holds,-1) == 1)
		//This is the last hold, so user is done
		be_app->PostMessage(B_QUIT_REQUESTED);
}


int32 DocumentApp::CountRegWindProcHolds()
{
	return m_window_and_process_holds;
}
